%% This is a first cell that clears workspace and memory
% Press Ctrl+enter to evaluate it
clear all; clc;

%% Load the CellCycle.txt model
model = SBmodel('CellCycle.txt')

%% Simulate using the SBsimulate command of the SBTOOLBOX2
%SBsimulate(model,400)
%SBsimulate(model,[0:1:400])
SBsimulate(model,'ode45',[0:2:400])             % simulate and plot
output = SBsimulate(model,'ode45',[0:2:400])    % simulate and return values

%% Learn more about the SBsimulate calling syntax:
help SBsimulate

%% Create a MATLAB ODE m-file from the SBmodel
SBcreateODEfile(model,'odefile')

%% Simulate the ODE file (no conversion overhead due to creation of ODE file)
tic;
[t,x] = ode15s('odefile',[0:1:400],odefile);
TIMEODE15S = toc
plot(t,x)

%% Using SBPDsimulate for simulation (SBmodel=>MEXmodel=>Simulation)
SBPDsimulate(model,[0:1:400])

%% Create MEX simulation function
SBPDmakeMEXmodel(model,'mexmodel')

%% Simulate the ODE file (no conversion overhead due to compilation of MEX files)
tic;
output = mexmodel([0:1:400]);
TIMEMEX = toc
plot(output.time,output.statevalues)

%% Calculate speed up MEX vs. ODE15S
MEX_is_timesfaster = TIMEODE15S/TIMEMEX

%% Simulate model with different initial conditions
initialConditions = ones(1,13);
SBsimulate(model,'ode45',[0:2:400],initialConditions)
SBPDsimulate(model,[0:2:400],initialConditions)
SBPDsimulate('mexmodel',[0:2:400],initialConditions)

%% Simulate model with different parameter settings
parameterNames = SBparameters(model) % List the parameters that are in the model
parameterNamesChange  = {'k1','V25p'};
parameterValuesChange = [0.1  0.3];
initialConditions     = []; % Use default initial conditions as stored in the model
SBPDsimulate('mexmodel',[0:2:400],initialConditions,parameterNamesChange,parameterValuesChange)

%% Conclusion:
% When repeated simulations are necessary (sensitivity analysis, parameter
% estimation, etc.) it is good to first create MEX simulation functions and
% subsequently to use these to do the simulations, avoiding the
% conversion and compilation overhead. Parameters and initial conditions
% can be changed by giving these information as input arguments to MEX
% simulation functions. More information can be found here:

help SBPDmakeMEXmodel